<?php
/**
 * Awesometabs class.
 *
 * @category   Class
 * @package    ElementorAwesometabs
 * @subpackage WordPress
 * @author     Uli Knapp with help from Ben Marshall <me@benmarshall.me>
 * @copyright  2021 Helloweb
 * @license    https://opensource.org/licenses/GPL-3.0 GPL-3.0-only
 * @link       link(https://www.benmarshall.me/build-custom-elementor-widgets/,
 *             Build Custom Elementor Widgets)
  * @link       www.helloweb.co.nz
 * @since      1.0.0
 * php version 7.3.9
 */

namespace ElementorAwesometabs\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

// Security Note: Blocks direct access to the plugin PHP files.
defined( 'ABSPATH' ) || die();

/**
 * Awesometabs widget class.
 *
 * @since 1.0.0
 */
class Awesometabs extends Widget_Base {
	/**
	 * Class constructor.
	 *
	 * @param array $data Widget data.
	 * @param array $args Widget arguments.
	 */
	public function __construct( $data = array(), $args = null ) {
		parent::__construct( $data, $args );

		wp_register_style( 'awesometabs', plugins_url( '/assets/css/awesometabs.css', ELEMENTOR_AWESOMETABS ), array(), '1.0.0' );
	}

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'awesometabs';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Awesometabs', 'elementor-awesometabs' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fa fa-pencil';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return array( 'general' );
	}

	/**
	 * Enqueue styles.
	 */
	public function get_style_depends() {
		return array( 'awesometabs' );
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
		protected function _register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'elementor-awesometabs' ),
    		]
		);


   		$this->add_control(
			'title',
			array(
				'label'   => __( 'title', 'elementor-awesometabs' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'title', 'elementor-awesometabs' ),
			)
		);

		$this->add_control(
			'description',
			array(
				'label'   => __( 'description', 'elementor-awesomestabs' ),
				'type'    => Controls_Manager::WYSIWYG,
				'default' => __( 'description', 'elementor-awesometabs' ),
			)
		);


		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'list_title', [
				'label' => __( 'Title', 'elementor-awesometabs' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'List Title' , 'elementor-awesometabs' ),
				'label_block' => true,
			]
		);

        $repeater->add_control(
			'list_icon', [
				'label' => __( 'Fa Icon', 'elementor-awesometabs' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'List Icon' , 'elementor-awesometabs' ),
				'label_block' => true,
			]
		);


				$repeater->add_control(
			'list_summary', [
				'label' => __( 'Summary', 'elementor-awesometabs' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'List Summary' , 'elementor-awesometabs' ),
				'label_block' => true,
	]
);


		$repeater->add_control(
			'list_content', [
				'label' => __( 'Content', 'elementor-awesomestabs' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'default' => __( 'List Content' , 'elementor-awesometabs' ),
				'show_label' => false,
			]
		);

		$repeater->add_control(
			'list_color',
			[
				'label' => __( 'Color', 'elementor-awesometabs' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}}' => 'color: {{VALUE}}'
				],
			]
		);

		$this->add_control(
			'list',
			[
				'label' => __( 'Repeater List', 'elementor-awesometabs' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'list_title' => __( 'Title #1', 'elementor-awesometabs' ),
						'list_content' => __( 'Item content. Click the edit button to change this text.', 'elementor-awesometabs' ),
					],
					[
						'list_title' => __( 'Title #2', 'elementor-awesometabs' ),
						'list_content' => __( 'Item content. Click the edit button to change this text.', 'elementor-awesometabs' ),
					],
				],
				'title_field' => '{{{ list_title }}}',
			]
		);

		$this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings_for_display();

        $this->add_inline_editing_attributes( 'title', 'none' );
		$this->add_inline_editing_attributes( 'description', 'basic' );

        ?>

<section class="design-process-section margin-bottom-30" id="process-tab">
    <div class="container">
        <!--section title -->
        <h2 class="b-clor text-align-center"><?php echo ( $settings['title']);?></h2>
        <p class="regular-text text-align-center"><?php echo ( $settings['description']);?></p>
        <!--end section title -->
        <div class="tabs row">
            <div class="col-xs-12">
                <!-- design process steps-->
                <!-- Nav tabs -->
                <ul class="nav nav-tabs process-model more-icon-preocess" role="tablist">

        <?php
		if ( $settings['list'] ) {
        $count=0;

			foreach (  $settings['list'] as $item ) {
			    $count=$count+1;
                if ($count==1) {
                    ?>
                    <li role="presentation" class="active">
                    <?php
                }
                else  {
                    ?>
                    <li role="presentation">
                    <?php
                }

                ?>
                  <a href="#<?php echo str_replace(' ','',$item['list_title']);?>" aria-controls="<?php echo str_replace(' ','',$item['list_title']);?>" role="tab" data-toggle="tab">
                            <div class="tab-number"><?php echo $item['list_icon'];?><br/><?php echo $item['list_title'];?><span class="summary-text"><p><?php echo $item['list_summary'];?></p></span></div>

                  </a>
                   </li>
                    <?php }  ?>

                                 </ul>
                     <?php }  ?>

                <!-- Tab panes -->
                <div class="tab-content">
        <?php
           $count=0;
			foreach (  $settings['list'] as $item ) {
			    $count=$count+1;
                if ($count==1) {
                   ?>
                   <div role="tabpanel" class="tab-pane active" id="<?php echo str_replace(' ','',$item['list_title']);?>">
                   <?php
                   }
                   else {
                   ?>
                    <div role="tabpanel" class="tab-pane" id="<?php echo str_replace(' ','',$item['list_title']);?>">
                   <?php
                   }
                   ?>
                        <div class="design-process-content">
                            <!-- <h3 class="semi-bold"><?php echo $item['list_icon'];?>. <?php echo $item['list_title'];?></h3>  -->
                            <div class="regular-text"><?php echo $item['list_content'];?></div>
                        </div>
                  </div>
                    <?php
             }
            ?>

            </div>    <!-- Tab-Content -->
        </div>    <!-- col-xs-12 -->
    </div>    <!-- Row -->
  </div>  <!-- Container -->
</section>


			<?php
  ?>
 <?php
	}

	protected function _content_template() {
	?>

    	<#
		view.addInlineEditingAttributes( 'title', 'none' );
		view.addInlineEditingAttributes( 'description', 'basic' );

		#>
        <h2 {{{ view.getRenderAttributeString( 'title' ) }}}>{{{ settings.title }}}</h2>
		<div {{{ view.getRenderAttributeString( 'description' ) }}}>{{{ settings.description }}}</div>

		<# if ( settings.list.length ) { #>
		<dl>
			<# _.each( settings.list, function( item ) { #>
				<dt class="elementor-repeater-item-{{ item._id }}">{{{ item.list_title }}}</dt>
				<br><p><dt>{{{ item.list_summary }}}</dt></p>
				<dd>{{{ item.list_content }}}</dd>
			<# }); #>
			</dl>
		<# } #>
		<?php
	}
}
